// /////////////////////////////////////////////////////////////////////////////
// DR DOBB'S CHALLENGES
//
// Filename       : EntityLaser.cpp
// Date           : February 2008
//
// Description    : Refer to description in corresponding header.
//
// ///////////////////////////////////////////////////////////////////////////


#include "EntityLaser.h"
#include "Level.h"
#include "Application.h"




EntityLaser::EntityLaser( Dobbs::EntityTypes EType ) :
  m_Active( false )
{

  m_Floating = true;

  SetRect( &m_CollisionRect, 0, 0, 32, 32 );

  switch ( EType )
  {
    case Dobbs::ENTITY_TYPE_LASER_D:
      SetFrame( Dobbs::ANIM_LASER_D );
      break;
    case Dobbs::ENTITY_TYPE_LASER_U:
      SetFrame( Dobbs::ANIM_LASER_U );
      break;
    case Dobbs::ENTITY_TYPE_LASER_R:
      SetFrame( Dobbs::ANIM_LASER_R );
      break;
    case Dobbs::ENTITY_TYPE_LASER_L:
      SetFrame( Dobbs::ANIM_LASER_L );
      break;
    case Dobbs::ENTITY_TYPE_LASER_H:
    case Dobbs::ENTITY_TYPE_LASER_V:
      m_CanSleep = false;
      m_DiesIfOutsideScreen = true;
      break;
  }

}



EntityLaser::~EntityLaser() 
{
}



void EntityLaser::OnEvent( const EntityEvent Event, int Param1, int Param2, const std::string& TextParam, Entity* pEntity )
{

  switch ( Event )
  {
    case EE_HURT:
      g_App.PlaySound( "GunHit" );
      break;
    case EE_KILLED:
      g_App.PlaySound( "Cannon.Explode" );
      break;
    case EE_BLOCKED_BOTTOM:
    case EE_BLOCKED_LEFT:
    case EE_BLOCKED_RIGHT:
    case EE_BLOCKED_TOP:
      if ( ( m_Type == Dobbs::ENTITY_TYPE_LASER_H )
      ||   ( m_Type == Dobbs::ENTITY_TYPE_LASER_V ) )
      {
        for ( int i = 0; i < 10; ++i )
        {
          Entity* pExplosion = m_pLevel->SpawnEntity( Dobbs::ENTITY_TYPE_PARTICLE_EXPLOSION, 0, GetX() + 16, GetY() + 16 );
          float   DX = rand() % 81 - 40.0f;
          float   DY = rand() % 81 - 40.0f;

          switch ( Event )
          {
            case EE_BLOCKED_BOTTOM:
              DY -= 80.0f;
              break;
            case EE_BLOCKED_LEFT:
              DX += 80.0f;
              break;
            case EE_BLOCKED_RIGHT:
              DX -= 80.0f;
              break;
            case EE_BLOCKED_TOP:
              DY += 80.0f;
              break;
          }
          pExplosion->SetVelX( DX );
          pExplosion->SetVelY( DY );
          pExplosion->SetLifeTime( 0.6f - ( rand() % 20 ) * 0.01f );
        }
        g_App.PlaySound( "Laser.Explode" );
        Die();
      }
      break;
    case EE_INIT:
      if ( m_ExtraData == 0 )
      {
        m_ExtraData = 100;
      }
      if ( ( m_Type == Dobbs::ENTITY_TYPE_LASER_D )
      ||   ( m_Type == Dobbs::ENTITY_TYPE_LASER_U )
      ||   ( m_Type == Dobbs::ENTITY_TYPE_LASER_L )
      ||   ( m_Type == Dobbs::ENTITY_TYPE_LASER_R ) )
      {
        if ( m_ExtraData2 == 1 )
        {
          m_Active = true;
          m_Health = 5;
        }
      }
      break;
  }
  Entity::OnEvent( Event, Param1, Param2, TextParam, pEntity );

}



void EntityLaser::UpdateTimed( Level& aLevel, float ElapsedTime )
{

  Entity::UpdateTimed( aLevel, ElapsedTime );

  if ( m_ExtraData2 == 1 )
  {
    if ( ( m_Type == Dobbs::ENTITY_TYPE_LASER_D )
    ||   ( m_Type == Dobbs::ENTITY_TYPE_LASER_U )
    ||   ( m_Type == Dobbs::ENTITY_TYPE_LASER_L )
    ||   ( m_Type == Dobbs::ENTITY_TYPE_LASER_R ) )
    {
      if ( m_pLevel->m_pPlayer )
      {
        if ( m_StateTime >= m_ExtraData * 0.01f )
        {
          m_StateTime -= m_ExtraData * 0.01f;
          Entity*   pShot = m_pLevel->SpawnEntity( Dobbs::ENTITY_TYPE_SHOT, 0, m_X + 16, m_Y + 16 );

          int   DX = m_pLevel->m_pPlayer->GetX() - m_X;
          int   DY = m_pLevel->m_pPlayer->GetY() - m_Y;

          int   Length = (int)sqrtf( (float)( DX * DX + DY * DY ) );

          if ( Length > 0 )
          {
            pShot->SetVelX( 100.0f * DX / Length );
            pShot->SetVelY( 100.0f * DY / Length );
          }
          g_App.PlaySound( "Laser.Shot" );
        }
      }
    }
  }

  switch ( m_Type )
  {
    case Dobbs::ENTITY_TYPE_LASER_D:
      if ( m_StateTime >= m_ExtraData * 0.01f )
      {
        m_StateTime -= m_ExtraData * 0.01f;
        if ( m_Active )
        {
          Entity*   pLaser = aLevel.SpawnEntity( Dobbs::ENTITY_TYPE_LASER_V, Dobbs::DIR_DOWN, m_X, m_Y + 32 );
          pLaser->SetVelY( 300.0f );

          g_App.PlaySound( "Laser.Shot" );
        }
      }
      break;
    case Dobbs::ENTITY_TYPE_LASER_U:
      if ( m_StateTime >= m_ExtraData * 0.01f )
      {
        m_StateTime -= m_ExtraData * 0.01f;
        if ( m_Active )
        {
          Entity*   pLaser = aLevel.SpawnEntity( Dobbs::ENTITY_TYPE_LASER_V, Dobbs::DIR_UP, m_X, m_Y - 32 );
          pLaser->SetVelY( -300.0f );

          g_App.PlaySound( "Laser.Shot" );
        }
      }
      break;
    case Dobbs::ENTITY_TYPE_LASER_R:
      if ( m_StateTime >= m_ExtraData * 0.01f )
      {
        m_StateTime -= m_ExtraData * 0.01f;
        if ( m_Active )
        {
          Entity*   pLaser = aLevel.SpawnEntity( Dobbs::ENTITY_TYPE_LASER_H, Dobbs::DIR_RIGHT, m_X + 32, m_Y );
          pLaser->SetVelX( 300.0f );

          g_App.PlaySound( "Laser.Shot" );
        }
      }
      break;
    case Dobbs::ENTITY_TYPE_LASER_L:
      if ( m_StateTime >= m_ExtraData * 0.01f )
      {
        m_StateTime -= m_ExtraData * 0.01f;
        if ( m_Active )
        {
          Entity*   pLaser = aLevel.SpawnEntity( Dobbs::ENTITY_TYPE_LASER_H, Dobbs::DIR_LEFT, m_X - 32, m_Y );
          pLaser->SetVelX( -300.0f );

          g_App.PlaySound( "Laser.Shot" );
        }
      }
      break;
  }

}